#ifndef _ONLINEPRESENCE_SONY_H
#define _ONLINEPRESENCE_SONY_H

#include "UnityNP.h"
#include "Mutex.h"

#include "UnityNP.h"

namespace UnityPlugin
{
	PRX_EXPORT ErrorCode PrxSetPresence(const char* text);
	PRX_EXPORT bool PrxSetPresenceIsBusy();
	PRX_EXPORT bool PrxPresenceGetLastError(ResultCode* result);

	class OnlinePresence
	{
	protected:
		SimpleLock m_Lock;
		bool m_Busy;
		ResultCode m_LastResult;


	public:
		OnlinePresence();
		~OnlinePresence() {};

		bool IsBusy();
		ErrorCode GetLastError() const { return m_LastResult.GetResult(); }
		bool GetLastError(ResultCode* result) const { *result = m_LastResult; return m_LastResult.GetResult() == NP_OK; }
		ErrorCode SetPresence(const char* text);
		bool ProcessEvent(const sce::Toolkit::NP::Event& event);
	};

	extern OnlinePresence gPresence;
}

#endif // _ONLINEPRESENCE_SONY_H
